from flask import Blueprint, request, jsonify
from app import db
from app.models import Product

bp = Blueprint('api', __name__)

@bp.route('/products', methods=['GET'])
def get_products():
    products = Product.query.all()
    return jsonify([{"id": p.id, "name": p.name, "price": p.price} for p in products])

@bp.route('/add-product', methods=['POST'])
def add_product():
    data = request.json
    new_product = Product(name=data['name'], price=data['price'], description=data.get('description'))
    db.session.add(new_product)
    db.session.commit()
    return jsonify({"message": "Product added successfully!"})

# Register Blueprint
app.register_blueprint(bp, url_prefix='/api')

