
#!/bin/bash

# Path to your application
APP_PATH="/home/myjezdjr/public_html/facebook"

echo "Starting application restructure..."

# Activate virtual environment
source /home/myjezdjr/virtualenv/public_html/facebook/3.12/bin/activate

# Create backup
echo "Creating backup..."
cd /home/myjezdjr/public_html
tar -czf facebook_backup_$(date +%Y%m%d_%H%M%S).tar.gz facebook/

# Clean up pycache directories
echo "Cleaning up pycache..."
rm -rf $APP_PATH/__pycache__
rm -rf $APP_PATH/_pycache_

# Restructure directories
echo "Restructuring directories..."
cd $APP_PATH

# Move files into app directory
mv models.py app/
mv routes.py app/
mv services.py app/

# Create __init__.py in app directory if it doesn't exist
cat > app/__init__.py << 'EOF'
from flask import Flask
from flask_sqlalchemy import SQLAlchemy
from flask_migrate import Migrate
import os
from dotenv import load_dotenv

db = SQLAlchemy()
migrate = Migrate()

def create_app():
    app = Flask(__name__)
    
    # Load environment variables
    load_dotenv()
    
    # Configure database
    app.config['SECRET_KEY'] = os.getenv('SECRET_KEY', 'default-secret-key')
    app.config['SQLALCHEMY_DATABASE_URI'] = os.getenv('DATABASE_URL', 'sqlite:///app.db')
    app.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False
    
    # Initialize extensions
    db.init_app(app)
    migrate.init_app(app, db)
    
    # Import and register blueprints
    from app.routes import bp as api_bp
    app.register_blueprint(api_bp, url_prefix='/api')
    
    return app
EOF

# Update wsgi.py
cat > wsgi.py << 'EOF'
from app import create_app

app = create_app()

if __name__ == "__main__":
    app.run()
EOF

# Update passenger_wsgi.py
cat > passenger_wsgi.py << 'EOF'
import sys
import os

INTERP = "/home/myjezdjr/virtualenv/public_html/facebook/3.12/bin/python"
if sys.executable != INTERP:
    os.execl(INTERP, INTERP, *sys.argv)

sys.path.append(os.getcwd())

from wsgi import app as application
EOF

# Set correct permissions
echo "Setting permissions..."
chmod -R 755 $APP_PATH
find $APP_PATH -type f -exec chmod 644 {} \;

# Touch restart file
echo "Triggering application restart..."
mkdir -p $APP_PATH/tmp
touch $APP_PATH/tmp/restart.txt

echo "Restructure complete!"
echo "A backup of your original files has been created at /home/myjezdjr/public_html/facebook_backup_*.tar.gz"
echo "Please verify the application is working correctly."
