import os
import subprocess
import time

def build_and_deploy():
    """Builds a Docker image and deploys it to the server."""

    # Build the Docker image
    print("Building Docker image...")
    build_command = "docker build -t my_product_app:latest ."
    os.system(build_command)

    # Push the image to a registry (if needed)
    # push_command = f"docker push your_registry/my_product_app:latest" 
    # os.system(push_command) 

    # Stop and remove any existing containers
    stop_containers_command = "docker-compose down"
    os.system(stop_containers_command)

    # Deploy the container using docker-compose
    deploy_command = "docker-compose up -d" 
    os.system(deploy_command)

    # Wait for the container to start
    time.sleep(10)  # Adjust the wait time as needed

    # Check if the application is running
    check_status_command = "docker ps -a | grep my_product_app"
    output = subprocess.check_output(check_status_command, shell=True).decode("utf-8")
    if "Up" in output:
        print("Application deployed successfully!")
    else:
        print("Deployment failed. Check container logs.")

if __name__ == "__main__":
    build_and_deploy()