from flask import Blueprint, request, jsonify
from app.services import BarcodeScanner, ImageRecognition, FacebookIntegration
from app.models import db, Product
import json

bp = Blueprint('api', __name__)

@bp.route('/scan', methods=['POST'])
def scan_product():
    if 'image' not in request.files:
        return jsonify({'error': 'No image provided'}), 400
        
    image = request.files['image']
    return jsonify({'message': 'Scan endpoint ready'})

@bp.route('/health', methods=['GET'])
def health_check():
    return jsonify({'status': 'healthy'})
